/**
 * Created by admin on 2017/6/26.
 *
 * 主服务
 */

import GameConfig from "../model/GameConfig";
import Service from "../../core/Service";
import * as api from '../net/api'
import {gameInfo} from "../model/data-center";
import {SCENE_FINAL_REWARD, SCENE_MENU} from "../model/constants";
import {PopUpManager} from "@alienlib/popup";
import SceneController from "../../core/view/SceneController";

class MainService extends Service {

	async start() {
		GameConfig.parseConfig();

		await super.start();

		await Promise.all([
			api.getInfo(),
			//api.getCredits(),
			//api.getPrizeInfo(drawPluginId),
			//api.plugDrawInfo(drawPluginId),
		])
	}

	afterStart() {
		const code = gameInfo.statusCode;
		const sceneName = code == 4 || code == 5 ? SCENE_FINAL_REWARD :
			SCENE_MENU;

		PopUpManager.removeAllPupUp();
		SceneController.popAll(sceneName);
	}
}

const mainService: MainService = new MainService();
export default mainService
