/**
 * Created by rockyl on 2018/10/11.
 *
 * 规则弹窗
 */

import CurseComponent from "@core/curse/CurseComponent";
import PanelController from "@core/view/PanelController";
import {PANEL_RULE} from "../model/constants";

export default class PanelRule extends CurseComponent {
	content: string;
	button: string;

	protected reset() {
		super.reset();

		const {labContent, btnConfirm} = this.host;
		labContent.text= this.content;
		btnConfirm.label = this.button;

		this.registerEvent(btnConfirm, egret.TouchEvent.TOUCH_TAP, this.onBtnConfirmTap, this);
	}

	private onBtnConfirmTap(event) {
		PanelController.instance.close(PANEL_RULE);
	}
}