/**
 * Created by rockyl on 2018/7/30.
 */

import { IModuleData, LayoutType, ResPriority, GConsole, ModuleType, GLang, ABNetManager } from "duiba-tc";
import { StageManager, ModuleManager, ResManager, WaitingModule, TlModuleName, Animation, MsgModule } from "duiba-tl";
import { ModuleName, RuleModule, GameStartModule, GameEndRankModule, GameWinnerModule, GameEndModule } from "duiba-wx";
import { DataManager, IGameCfgData, NetManager, Buried } from "duiba-tw";

window.addEventListener("load", function () {
	window['_error_storage_'] = [];
	window['ERROR_CONFIG'] = {
		client: "duiba-game",
		pageId: window['CFG'].oaId || window['CFG'].gameInfo.oaId,
		imgUrl: "http://retcode.tuipink.com/report?"
	};

	function r() {
		window['_error_storage_'] && window['_error_storage_'].push([].slice.call(arguments))
	}
	window.addEventListener && window.addEventListener("error", r, true);
	var t = 3,
		n = function e() {
			var r = document.createElement("script");
			r.async = !0, r.src = "//yun.tuia.cn/tuia/skyeye/skyeye.js", r.crossOrigin = "anonymous", r.onerror =
				function () {
					t--, t > 0 && setTimeout(e, 1500)
				}, document.head && document.head.appendChild(r)
		};
	setTimeout(n, 1500);
	// const str = GFun.replace('1{0}2',['haha']);
	// alert(str);
	new Main();
});

class Main {
	/**
	 * 舞台
	 */
	private stage: annie.Stage;

	constructor() {
		annie.debug = false;
		window['A2xExtend'] = window['__extends'];
		/**
		 * 最上层div的id,可以在一个页面同时放多个stage.
		 * 设计尺寸的宽
		 * 设计尺寸的高
		 * FPS刷新率
		 * 缩放模式
		 * 渲染模式
		 */
		this.stage = new annie.Stage("annieEngine", 750, 1206, 60, annie.StageScaleMode.FIXED_WIDTH, 0);
		//默认关闭自动旋转和自动resize
		//stage.autoResize=true;
		//stage.autoSteering=true;

		this.stage.addEventListener(annie.Event.ON_INIT_STAGE, this.onAddToStage.bind(this));
	}

	private onAddToStage(e: annie.Event): void {
		if(!annie._isReleased){
			ABNetManager.baseUrl = 'http://172.31.49.77:3000';
		}
		DataManager.ins.gameCfgData = window['CFG'];
		DataManager.ins.gameCfgData.gameInfo.gameId = window['gameId'] || '0';
		NetManager.ins.getInfo(() => {
			var modules: IModuleData[] = [];
			if (DataManager.ins.getInfoData.status.code == 4) {
				//this.commonModules = this.commonModules.concat(this.endModules2);
			} else if (DataManager.ins.getInfoData.status.code == 5) {
				//this.commonModules = this.commonModules.concat(this.endModules1);
			} else {
				modules = modules.concat(this.openModules);
			}
			StageManager.ins.init(this.stage, LayoutType.TOP, 1386, 1030);
			initStage();
			Buried.init();
			ModuleManager.ins.init(modules, this.waitingModule, this.msgModule, this.loadingModule);

			let resPath = window['resPath'] || '';
			console.log(resPath);
			ResManager.ins.loadRes(resPath, this.onResProgress.bind(this));
		});
	}

	private onResProgress(step: ResPriority): void {
		if (step == ResPriority.PRE) {
			GConsole.log(GLang.lang_001);
		} else if (step == ResPriority.NOMARL) {
			let avatars = [];
			for(let i = 0; i < sexConfig.length; i++){
				avatars.push({url: `idol-avatars-2/${i}.png`, name: 'avatar_' + i});
			}
			setAssetsPath(window['commonResPath'] || '');
			loadResItems(avatars, function(p){
				//console.log('load avatars:', p)
			});

			GConsole.log(GLang.lang_002);

			var code: number = DataManager.ins.getInfoData.status.code;
			if (code == 5) {
				NetManager.ins.winRanks(() => {
					ModuleManager.ins.openModule(ModuleName.GAME_WINNER_SCENE);
				});
			} else {
				if (code == 4) {
					ModuleManager.ins.openModule(ModuleName.GAME_END_SCENE);
				} else {
					ModuleManager.ins.openModule(ModuleName.GAME_START_SCENE);
				}
			}
		} else if (step == ResPriority.DELAY) {
			GConsole.log(GLang.lang_003);
		}
	}

	private loadingModule: IModuleData;

	private waitingModule: IModuleData = {
		moduleName: TlModuleName.WAITING_PANEL,
		moduleClass: WaitingModule,
		viewClass: 'waitingSkin.WaitingSkin',
		res: 'waitingSkin',
		resPriority: ResPriority.PRE,
		type: ModuleType.PANEL,
		layerIndex: 2,
		showBg: true,
		eventPenetrate: false,
		showAnimation: Animation.showPanel,
		hideAnimation: null
	};

	private msgModule: IModuleData = {
		moduleName: TlModuleName.MSG_PANEL,
		moduleClass: MsgModule,
		viewClass: 'msgSkin.MsgSkin',
		res: 'msgSkin',
		resPriority: ResPriority.DELAY,
		type: ModuleType.PANEL,
		layerIndex: 3,
		showBg: true,
		eventPenetrate: false,
		showAnimation: Animation.showPanel,
		hideAnimation: null
	}

	/**
	 * 活动开启模块
	 */
	private openModules: IModuleData[] = [
		{
			moduleName: ModuleName.GAME_START_SCENE,
			moduleClass: ExGameStartModule,
			viewClass: 'gameStartSkin.GameStartSkin',
			res: 'gameStartSkin',
			resPriority: ResPriority.NOMARL,
			type: ModuleType.SCENE,
			layerIndex: 1,
			showBg: false,
			eventPenetrate: false,
			showAnimation: null,
			hideAnimation: Animation.hideScene
		},
		{
			moduleName: ModuleName.GAME_GUIDE_SCENE,
			moduleClass: GameGuideModule,
			viewClass: 'gameGuideSkin.GameGuideSkin',
			res: 'gameGuideSkin',
			resPriority: ResPriority.DELAY,
			type: ModuleType.SCENE,
			layerIndex: 1,
			showBg: false,
			eventPenetrate: false,
			showAnimation: null,
			hideAnimation: Animation.hideScene
		},
		{
			moduleName: ModuleName.GAME_PLAY_SCENE,
			moduleClass: ExGamePlayModule,
			viewClass: 'gamePlaySkin.GamePlaySkin',
			res: 'gamePlaySkin',
			resPriority: ResPriority.DELAY,
			type: ModuleType.SCENE,
			layerIndex: 1,
			showBg: false,
			eventPenetrate: false,
			showAnimation: null,
			hideAnimation: Animation.hideScene
		},
		{
			moduleName: GROUP_PHOTO_SCENE,
			moduleClass: GroupPhotoModule,
			viewClass: 'groupPhotoSkin.GroupPhotoSkin',
			res: 'groupPhotoSkin',
			resPriority: ResPriority.DELAY,
			type: ModuleType.SCENE,
			layerIndex: 1,
			showBg: false,
			eventPenetrate: false,
			showAnimation: null,
			hideAnimation: Animation.hideScene
		},
		{
			moduleName: SHARE_SCENE,
			moduleClass: ShareModule,
			viewClass: 'shareSkin.ShareSkin',
			res: 'shareSkin',
			resPriority: ResPriority.DELAY,
			type: ModuleType.SCENE,
			layerIndex: 1,
			showBg: false,
			eventPenetrate: false,
			showAnimation: null,
			hideAnimation: Animation.hideScene
		},
	];
}
