/**
 * @note   函数 window.downloadApp
 * @modify by zsl@duiba.com.cn
 * @date   2016-07-31
 * @modify 2016-09-01
 */
;
(function ($) {

	var ua = navigator.userAgent.toLowerCase();

	// -------------------------- downloadApp主要函数  --------------------------//
	var downloadApp = function () {
		if (window.downloadAppConfig) {
			if (ua.match(/iphone/ig) || ua.match(/ipad/ig)) {
				//ios
				download();
			} else {
				if (window.downloadAppConfig.confirm || window.downloadAppConfig.confirm == 'true') {
					$.modal({
						type: 'confirm',
						title: '下载确认',
						section: '即将开始下载，是否继续',
						callback: {
							save: function () {
								if (window.downloadAppConfig.stats) {
									$.ajax({
										url: window.downloadAppConfig.stats,
										complete: function () {
											download();
										}
									})
								} else {
									download();
								}
							}
						}
					})
				} else {
					download();
				}
			}
		} else {
			console.error('请先配置参数window.downloadAppConfig');
		}
	}

	// -------------------------- format函数  --------------------------//
	var formatUrl = function (downloadUrl) {
		if (downloadUrl.indexOf('dbnewopen') != -1) {
			window.location.href = downloadUrl;
		} else {
			if (downloadUrl.indexOf('?') !== -1) {
				// modify by zsl date2016-07-28
				if (downloadUrl.indexOf('#') !== -1) {
					// 如果包含#号
					window.location.href = downloadUrl.split('#')[0] + '&dbnewopen#' + downloadUrl.split('#')[1];
				} else {
					window.location.href = downloadUrl + '&dbnewopen';
				}
			} else if (downloadUrl !== '') {
				window.location.href = downloadUrl + '?dbnewopen';
			}
		}
	}

	// -------------------------- URL处理函数  --------------------------//
	var download = function () {

		var openUrl = window.downloadAppConfig.openUrl || '';
		var downloadUrl = '';

		// 淘客url处理  start ------------------------------------------------------------
		var TKHelper,
			isSpecial = false;

		if (window.TBSDK_ADA !== undefined) {

			TKHelper = function (downloadUrl) {

				var isTBSDK = function () {
					isSpecial = true;

					if (window.isSpecialApp) {
						window.location.href = downloadUrl;
					} else {
						window.BC_SDK.openPage({
							url: downloadUrl
						});
					}
				};

				// 如果包含手淘url 唤起手淘App的功能
				if (downloadUrl.indexOf('taoquan.taobao.com') !== -1 || downloadUrl.indexOf('shop.m.taobao.com') !== -1) {
					window.BC_SDK = TBSDK_ADA.init({
						"appkey": '23402401',
						openTBAPP: true
					});

					isTBSDK();
				}
				// 如果是s.click.taobao.com的URL，点击则调用百川goTaoke方法唤起手淘
				if (downloadUrl.indexOf('s.click.taobao.com') !== -1) {
					window.BC_SDK = TBSDK_ADA.init({
						"appkey": '23454468',
						"appSecret": '3846ae97316a0b31321a8f493f826986',
						openTBAPP: true
					});

					isTBSDK();
				}
			};
		}
		// 淘客url处理  end  -----------------------------------------------------------

		// 特殊处理
		var handleSpecial = function (downloadUrl) {

			// 如果downloadUrl是weixin直接打开url（加了&dbnewopen  SDK唤起weixin 中间会产生一个空白页）
			if (downloadUrl && downloadUrl.indexOf('weixin://') !== -1) {
				isSpecial = true;
				window.location.href = downloadUrl;
				return;
			}

			// @special openUrl为微信服务，
			if (openUrl && openUrl.indexOf('weixin://') !== -1) {
				return;
			}

			// 如果含有手淘url 唤起手淘App的功能
			if (window.TBSDK_ADA !== undefined) {
				TKHelper(downloadUrl);
			}
		};

		if (ua.match(/iphone/ig) || ua.match(/ipad/ig)) {
			// ios
			downloadUrl = window.downloadAppConfig.iosDownloadUrl;

			handleSpecial(downloadUrl);
			if (isSpecial) {
				return;
			}

			if (ua.match(/MicroMessenger/ig)) {
				formatUrl(downloadUrl);
			} else {
				if (openUrl) {
					window.location.href = openUrl;
				} else {
					if (downloadUrl.indexOf('itunes.apple.com') != -1) {
						var ifr = document.createElement('iframe');
						ifr.src = downloadUrl;
						ifr.style.display = 'none';
						window.setTimeout(function () {
							document.body.appendChild(ifr);
						}, 300)
					} else {
						formatUrl(downloadUrl);
					}
				}
			}

		} else {
			// android
			downloadUrl = window.downloadAppConfig.androidDownloadUrl;

			handleSpecial(downloadUrl);
			if (isSpecial) {
				return;
			}

			// 如果有oepnUrl
			if (openUrl) {
				window.location.href = openUrl;
				return;
			}

			if (downloadUrl.indexOf('.apk') != -1 || downloadUrl.indexOf('dbnewopen') != -1) {
				window.location.href = downloadUrl;
			} else {
				formatUrl(downloadUrl);
			}
		}
	}

	window.downloadApp = downloadApp;
})(Zepto);
