/**
 * Created by rockyl on 2018/7/6.
 */
const gutil = require('gulp-util');
const chalk = require('chalk');
const prettyTime = require('pretty-hrtime');

let gulpConfigFile;
let gulpConfig;
let cb;

exports.loadGulpFile = function (file) {
	gulpConfig = require(gulpConfigFile = file);
};

exports.setTsConfig = function (tsConfig){
	//gulpConfig.setTsConfig(tsConfig);
};

exports.startGulpTask = function(tasks = ['default'], callback, name){
	gulpConfig.setConfig({
		callback: cb = callback,
		name
	});

	const gulpInst = require('gulp');
	logEvents(gulpInst);

	process.nextTick(function() {
		gulpInst.start.apply(gulpInst, tasks);
	});
};

// Format orchestrator errors
function formatError(e) {
	if (!e.err) {
		return e.message;
	}

	// PluginError
	if (typeof e.err.showStack === 'boolean') {
		return e.err.toString();
	}

	// Normal error
	if (e.err.stack) {
		return e.err.stack;
	}

	// Unknown (string, number, etc.)
	return new Error(String(e.err)).stack;
}

// Wire up logging events
function logEvents(gulpInst) {

	// Total hack due to poor error management in orchestrator
	gulpInst.on('err', function() {
		//failed = true;
	});

	gulpInst.on('task_start', function(e) {
		// TODO: batch these
		// so when 5 tasks start at once it only logs one time with all 5
		gutil.log('Starting', '\'' + chalk.cyan(e.task) + '\'...');
	});

	gulpInst.on('task_stop', function(e) {
		var time = prettyTime(e.hrDuration);
		gutil.log(
			'Finished', '\'' + chalk.cyan(e.task) + '\'',
			'after', chalk.magenta(time)
		);
	});

	gulpInst.on('task_err', function(e) {
		var msg = formatError(e);
		var time = prettyTime(e.hrDuration);
		gutil.log(
			'\'' + chalk.cyan(e.task) + '\'',
			chalk.red('errored after'),
			chalk.magenta(time)
		);
		if (e.err && e.err.loc) {
			let {file, line, column} = e.err.loc;
			gutil.log(`[${line}, ${column}] ` + file);
		}
		gutil.log(msg);
		cb(new Error('task_err'))
	});

	gulpInst.on('task_not_found', function(err) {
		gutil.log(
			chalk.red('Task \'' + err.task + '\' is not in your gulpfile')
		);
		gutil.log('Please check the documentation for proper gulpfile formatting');
		process.exit(1);
	});
}