/**
 * Created by rockyl on 2018/7/9.
 */

const gulp = require('gulp');
const rollup = require('rollup');
const {uglify} = require('rollup-plugin-uglify');
const resolve = require('rollup-plugin-node-resolve');
const commonjs = require('rollup-plugin-commonjs');
const typescript = require('rollup-plugin-typescript2');

let currentMode = 'debug';
let version, releasePath;
let completeCallback;

exports.setCallback = function (callback) {
	completeCallback = callback;
};

gulp.task('compileTs', async function () {
	let plugins = [
		resolve({
			browser: true,
		}),
		typescript({
			typescript: require('typescript'),
			include: ['**/*.ts', '../common/**/*.ts', '../../src/**/*.ts'],
		}),
		commonjs(),
	];

	if (currentMode === 'build') {
		plugins.push(uglify());
	}

	let file = currentMode === 'debug' ?
		`debug/bundle.js` :
		releasePath + 'bundle.js';

	let writeConfig = {
		file,
		format: 'cjs',
	};

	if (currentMode === 'debug') {
		writeConfig.sourcemap = true;
	}

	const bundle = await rollup.rollup({
		input: './src/main.ts',
		plugins,
	});
	await bundle.write(writeConfig);
});

gulp.task('watch', function () {
	gulp.watch('src/**', ['compile']);
});

gulp.task('dev', ['compileTs', 'watch'], function(cb){
	completeCallback && completeCallback('success');
	cb();
});

gulp.task('compile', ['compileTs'], function(cb){
	completeCallback && completeCallback('success');
	cb();
});

gulp.task('build', async function () {
	currentMode = 'build';
	version = Math.floor(Date.now() / 1000).toString();
	releasePath = `dist/${version}/`;
	gulp.start(['compileTs', ], function(){
		console.log('build success! \nversion:', version);
		completeCallback && completeCallback(version);
	});
});
