/**
 * Created by rockyl on 2018/7/9.
 */

const path = require('path');
const gulp = require('gulp');
const glob = require('glob');
const rollup = require('rollup');
const {uglify} = require('rollup-plugin-uglify');
const resolve = require('rollup-plugin-node-resolve');
const commonjs = require('rollup-plugin-commonjs');
const typescript = require('rollup-plugin-typescript2');
const replace = require('rollup-plugin-replace');
const livereload = require('gulp-livereload');
const runSequence = require('run-sequence');

let currentMode = 'debug';
let version, releasePath;
let completeCallback, umdName;

exports.setConfig = function (config) {
	const {callback, name} = config;
	completeCallback = callback;
	umdName = name;
};

const tsPaths = ['**/*.ts'];
const tsconfig = require(path.resolve('tsconfig.json'));
const pathsConfig = tsconfig.compilerOptions.paths;
//console.log(pathsConfig);
if (pathsConfig) {
	for (let key in pathsConfig) {
		let paths = pathsConfig[key];
		for (let path of paths) {
			if (path[path.length - 1] === '*') {
				path += '*/*.ts';
			} else {
				try {
					path = path.replace(/index$/, '**/*.ts')
				} catch (e) {
					console.log(e);
				}
			}
			tsPaths.push(path);
		}
	}
}

gulp.task('executeScripts', async function () {
	const files = glob.sync("scripts/*.js");
	for (const file of files) {
		try {
			const process = require(path.resolve(file));
			await process.execute();
		} catch (e) {
			console.log(e);
		}
	}
});

gulp.task('copy-res', async function () {
	gulp.src('resource/**/*')
		.pipe(gulp.dest(path.join(releasePath, 'resource')))
});

gulp.task('compileTs', async function () {
	let plugins = [
		resolve({
			browser: true,
		}),
		typescript({
			typescript: require('typescript'),
			include: tsPaths,
		}),
		commonjs(),
	];

	if (currentMode === 'build') {
		plugins.push(uglify({
			//keep_fnames: true,
			//toplevel: true,
			mangle: {
				//properties: true,
				reserved: [umdName, 'startup', 'userAgent'],
			}
		}));
		plugins.push(
			replace({
				'DEBUG': JSON.stringify(false),
				'RELEASE': JSON.stringify(true),
			})
		)
	} else {
		plugins.push(
			replace({
				'process.env.NODE_ENV': JSON.stringify('development'),
				'process.env.VUE_ENV': JSON.stringify('browser'),
				'DEBUG': JSON.stringify(true),
				'RELEASE': JSON.stringify(false),
			})
		)
	}

	let file = currentMode === 'debug' ?
		`debug/bundle.js` :
		releasePath + 'bundle.js';

	let writeConfig = {
		file,
		format: 'umd',
		name: umdName,
	};

	if (currentMode === 'debug') {
		writeConfig.sourcemap = true;
	}

	const bundle = await rollup.rollup({
		input: './src/main.ts',
		plugins,
	});
	await bundle.write(writeConfig);

	gulp.start(['reload']);
});

gulp.task('reload', function () {
	gulp.src(['debug/**/*.js', 'assets/**/*.+(scene|pfb)'])
		.pipe(livereload());
});

gulp.task('watch', function () {
	livereload.listen({
		quiet: true,
	});
	gulp.watch(['src/**/*.+(ts|js)', 'assets/**/*.+(ts)'], ['compile']);
});

gulp.task('dev', ['compile', 'watch'], function (cb) {
	//completeCallback && completeCallback('success');
	cb();
});

gulp.task('compile', function (cb) {
	runSequence('executeScripts', 'compileTs', function () {
		//completeCallback && completeCallback('success');
		cb();
	});
});

gulp.task('build', async function () {
	currentMode = 'build';
	version = Math.floor(Date.now() / 1000).toString();
	releasePath = `dist/${version}/`;
	gulp.start(['compile', 'copy-res'], function () {
		console.log('build success! \nversion:', version);
		completeCallback && completeCallback(version);
	});
});
