"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchApi = exports.setup = void 0;
require("./object-assign-polyfill");
const querystringify_1 = require("querystringify");
const builtin_successfully_judges_1 = require("./builtin-successfully-judges");
__exportStar(require("./builtin-successfully-judges"), exports);
class ApiError extends Error {
    constructor(name, code, message) {
        super();
        this.code = 0;
        this.details = '';
        if (name) {
            this.name = name;
        }
        if (code) {
            this.code = code;
        }
        if (message) {
            this.message = message;
        }
    }
}
let _options = {
    apiHost: '',
    successfullyJudge: builtin_successfully_judges_1.codeOnlyMode,
    messageField: 'msg',
};
function setup(options) {
    Object.assign(_options, options);
}
exports.setup = setup;
async function fetchApi(uri, { host = '', params, headers = {}, method = 'get', credentials = 'include', contentType = 'json', errMessage, } = {}) {
    let url = host +
        (uri.startsWith('http') || uri.startsWith('//') ? uri : _options.apiHost + uri);
    const options = {
        method,
        headers: Object.assign({}, headers),
        credentials,
    };
    if (params) {
        if (method.toLowerCase() === 'post') {
            switch (contentType) {
                case 'form-data':
                    let formData = new FormData();
                    for (let key in params) {
                        let value = params[key];
                        if (value instanceof File) {
                            formData.append(key, value, value.name);
                        }
                        else {
                            formData.append(key, value);
                        }
                    }
                    options.body = formData;
                    break;
                case 'form':
                    options.headers['Content-Type'] = 'application/x-www-form-urlencoded';
                    options.body = (0, querystringify_1.stringify)(params);
                    break;
                case 'json':
                    options.headers['Content-Type'] = 'application/json';
                    options.body = JSON.stringify(params);
                    break;
            }
        }
        else {
            url += url.indexOf('?') < 0 ? '?' : '';
            url += (url.endsWith('?') ? '' : '&') + (0, querystringify_1.stringify)(params);
        }
    }
    try {
        let fetchMethod = _options.fetch;
        const response = await fetchMethod(url, options);
        const respText = await response.text();
        if (response.status === 310) {
            console.log('重定向到:' + respText);
            try {
                location.href = respText;
            }
            catch (e) {
            }
        }
        let jsonObj = JSON.parse(respText);
        if (_options.successfullyJudge(jsonObj)) {
            return jsonObj.data;
        }
        console.log(jsonObj);
        return Promise.reject(new ApiError('call api failed', jsonObj.code, errMessage || jsonObj[_options.messageField]));
    }
    catch (e) {
        return Promise.reject(e);
    }
}
exports.fetchApi = fetchApi;
//# sourceMappingURL=index.js.map