/**
 * Created by rockyl on 2020/8/18.
 */

import fetch from 'node-fetch'
import * as config from "config"

export let remoteConfigs = {}

export async function prepare() {
	const remoteConfigUrl:string = config.get('remote_config_url')
	const resp = await fetch(remoteConfigUrl)
	const originConfigs = await resp.json()
	//logger.info('originConfigs:', originConfigs)

	remoteConfigs = originConfigs.propertySources.reduce((prev, item) => {
		return Object.assign(prev, item.source)
	}, {})
}

export function getConfigs(...args):any {
	let configs = {}
	for (let arg of args) {
		let name = arg
		let mapKey = arg
		if (typeof arg === 'object') {
			name = arg.alias
			mapKey = arg.name
		}
		configs[name] = remoteConfigs[mapKey]
	}
	return configs
}
