/**
 * Created by rockyl on 2020-02-13.
 */

import {configure, getLogger} from 'log4js'
const path = require("path")
const fs = require("fs-extra")

const logPath = path.join(process.env.HOME || process.env.USERPROFILE as string, 'logs', 'tiny-image')

fs.ensureDir(logPath)

configure({
	appenders: {
		out: {type: 'console'},
		allLog: {
			type: 'dateFile',
			filename: path.join(logPath, 'log.log'),
		},
	},
	categories: {
		default: {appenders: ['out', 'allLog'], level: 'debug'},
	}

})

const logger = getLogger()

export default logger
