/**
 * Created by rockyl on 2021/11/5.
 */

const {buffer: imagemin} = require("imagemin")
const imageminJpegtran = require("imagemin-jpegtran-cn")
const imageminPngquant = require("imagemin-pngquant-cn")

import {compress} from 'node-tinify'

enum COMPRESS_TYPE {
	builtin = 'builtin',
	tinypng = 'tinypng',
}

export function compressImage(buffer: Buffer, type: COMPRESS_TYPE) {
	if (!COMPRESS_TYPE[type]) {
		type = COMPRESS_TYPE.builtin
	}
	switch (type) {
		case COMPRESS_TYPE.builtin:
			return imagemin(buffer, {
				plugins: [
					imageminJpegtran(),
					imageminPngquant({
						quality: [0.6, 0.8]
					})
				]
			})
		case COMPRESS_TYPE.tinypng:
			return compress(buffer, {returnType: 'buffer'})
	}
}
