"use strict";
/**
 * Created by rockyl on 2020/8/18.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConfigs = exports.prepare = exports.remoteConfigs = void 0;
const node_fetch_1 = require("node-fetch");
const config = require("config");
exports.remoteConfigs = {};
async function prepare() {
    const remoteConfigUrl = config.get('remote_config_url');
    const resp = await (0, node_fetch_1.default)(remoteConfigUrl);
    const originConfigs = await resp.json();
    //logger.info('originConfigs:', originConfigs)
    exports.remoteConfigs = originConfigs.propertySources.reduce((prev, item) => {
        return Object.assign(prev, item.source);
    }, {});
}
exports.prepare = prepare;
function getConfigs(...args) {
    let configs = {};
    for (let arg of args) {
        let name = arg;
        let mapKey = arg;
        if (typeof arg === 'object') {
            name = arg.alias;
            mapKey = arg.name;
        }
        configs[name] = exports.remoteConfigs[mapKey];
    }
    return configs;
}
exports.getConfigs = getConfigs;
//# sourceMappingURL=remote-configs.js.map