"use strict";
/**
 * Created by rockyl on 2020-02-13.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const log4js_1 = require("log4js");
const path = require("path");
const fs = require("fs-extra");
const logPath = path.join(process.env.HOME || process.env.USERPROFILE, 'logs', 'tiny-image');
fs.ensureDir(logPath);
(0, log4js_1.configure)({
    appenders: {
        out: { type: 'console' },
        allLog: {
            type: 'dateFile',
            filename: path.join(logPath, 'log.log'),
        },
    },
    categories: {
        default: { appenders: ['out', 'allLog'], level: 'debug' },
    }
});
const logger = (0, log4js_1.getLogger)();
exports.default = logger;
//# sourceMappingURL=logger.js.map