"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Created by rockyl on 2020-02-12.
 */
const remote_configs_1 = require("./remote-configs");
const restify = require('restify');
const eureka_1 = require("./eureka");
const logger_1 = require("./logger");
const config = require("config");
const api_1 = require("./api");
const ali_oss_duiba_1 = require("ali-oss-duiba");
const cors_1 = require("./cors");
const redis_1 = require("./redis");
let eureka;
const server = restify.createServer({
    name: 'tiny-image',
    version: '1.0.0'
});
const ignoreUrlLogger = ['/monitor/check'];
server.use(restify.plugins.acceptParser(server.acceptable));
server.use(restify.plugins.queryParser());
server.use(restify.plugins.bodyParser());
server.use((0, cors_1.default)());
server.use(function (req, res, next) {
    if (!ignoreUrlLogger.includes(req.url)) {
        logger_1.default.info(req.url);
    }
    return next();
});
(0, api_1.default)(server);
process.on('uncaughtException', (err) => {
    logger_1.default.error(err);
});
process.on("SIGTERM", () => {
    eureka.stop();
    setTimeout(() => {
        process.exit(1);
    }, 6000);
});
async function start() {
    await (0, remote_configs_1.prepare)();
    const ossConfigs = (0, remote_configs_1.getConfigs)({ name: `apollo.oss.duiba.accessId`, alias: 'accessId' }, { name: `apollo.oss.duiba.accessKey`, alias: 'accessKey' }, { name: `apollo.oss.duiba.bucketName`, alias: 'bucketName' });
    logger_1.default.info('got oss configs:\n', ossConfigs);
    const redisConfigs = (0, remote_configs_1.getConfigs)({ name: `apollo.redis.duiba-tiny-image-node.host`, alias: 'host' }, { name: `apollo.redis.duiba-tiny-image-node.port`, alias: 'port' }, { name: `apollo.redis.duiba-tiny-image-node.password`, alias: 'password' });
    logger_1.default.info('got redis configs:\n', redisConfigs);
    (0, ali_oss_duiba_1.setup)({
        accessKeyId: ossConfigs.accessId,
        accessKeySecret: ossConfigs.accessKey,
        bucket: ossConfigs.bucketName,
        region: 'oss-cn-hangzhou',
    });
    await (0, redis_1.prepareRedis)(redisConfigs);
    const port = config.get('PORT');
    server.listen(port, async function () {
        if (process.env.NODE_ENV) {
            try {
                eureka = await (0, eureka_1.getEurekaClient)(port);
                logger_1.default.info('eureka register success');
            }
            catch (e) {
                logger_1.default.error(e.name);
            }
        }
        logger_1.default.info('%s listening at %s', server.name, server.url);
    });
}
start().catch(e => {
    console.log(e);
    process.exit(2);
});
//# sourceMappingURL=index.js.map