import {createClient, RedisClient} from 'redis'
import logger from "./logger"

export let redisClient: RedisClient

export function prepareRedis(configs) {
	const {host, port, password, db = 11} = configs
	redisClient = createClient(port, host, {
		db,
	})
	redisClient.on('error', function (err) {
		logger.info('redis error:', err)
	})

	return new Promise((resolve, reject) => {
		redisClient.auth(password, function (err, reply) {
			if (err) {
				reject(err)
			} else {
				resolve(reply)
			}
		})
	})
}

export function getUrlFromCache(hashs: string[], ns: string = 'default'): Promise<string[]> {
	const nsHashs = hashs.map(hash => ns + ':' + hash)

	return new Promise((resolve, reject) => {
		redisClient.mget(nsHashs, function (err, replies) {
			if (err) {
				reject(err)
			} else {
				resolve(replies)
			}
		})
	})
}

export function setUrlToCache(data: any, ns: string = 'default') {
	return new Promise((resolve, reject) => {
		const entries = Object.entries(data)
		if (entries.length > 0) {
			let kvs: string[] = []
			entries.forEach(([key, value]) => {
				kvs.push(ns + ':' + key, value as string)
			})
			redisClient.mset(kvs, function (err, success) {
				if (err) {
					reject(err)
				} else {
					resolve(true)
				}
			})
		} else {
			resolve(false)
		}
	})
}
