"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setUrlToCache = exports.getUrlFromCache = exports.prepareRedis = exports.redisClient = void 0;
const redis_1 = require("redis");
const logger_1 = require("./logger");
function prepareRedis(configs) {
    const { host, port, password, db = 11 } = configs;
    exports.redisClient = (0, redis_1.createClient)(port, host, {
        db,
    });
    exports.redisClient.on('error', function (err) {
        logger_1.default.info('redis error:', err);
    });
    return new Promise((resolve, reject) => {
        exports.redisClient.auth(password, function (err, reply) {
            if (err) {
                reject(err);
            }
            else {
                resolve(reply);
            }
        });
    });
}
exports.prepareRedis = prepareRedis;
function getUrlFromCache(hashs, ns = 'default') {
    const nsHashs = hashs.map(hash => ns + ':' + hash);
    return new Promise((resolve, reject) => {
        exports.redisClient.mget(nsHashs, function (err, replies) {
            if (err) {
                reject(err);
            }
            else {
                resolve(replies);
            }
        });
    });
}
exports.getUrlFromCache = getUrlFromCache;
function setUrlToCache(data, ns = 'default') {
    return new Promise((resolve, reject) => {
        const entries = Object.entries(data);
        if (entries.length > 0) {
            let kvs = [];
            entries.forEach(([key, value]) => {
                kvs.push(ns + ':' + key, value);
            });
            exports.redisClient.mset(kvs, function (err, success) {
                if (err) {
                    reject(err);
                }
                else {
                    resolve(true);
                }
            });
        }
        else {
            resolve(false);
        }
    });
}
exports.setUrlToCache = setUrlToCache;
//# sourceMappingURL=redis.js.map