"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEurekaClient = void 0;
const eureka_client_ts_1 = require("eureka-client-ts");
const logger_1 = require("./logger");
const eurekaConfig = {
    appName: 'duiba-tiny-image-node',
    services: ['duiba-tiny-image-node'],
};
async function getEurekaClient(port) {
    eurekaConfig.port = port;
    let eureka;
    try {
        eureka = new eureka_client_ts_1.default(eurekaConfig);
        await eureka.start();
    }
    catch (e) {
        logger_1.default.error(e);
    }
    return eureka;
}
exports.getEurekaClient = getEurekaClient;
//# sourceMappingURL=eureka.js.map