"use strict";
/**
 * Created by rockyl on 2021/11/5.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.compressImage = void 0;
const { buffer: imagemin } = require("imagemin");
const imageminJpegtran = require("imagemin-jpegtran-cn");
const imageminPngquant = require("imagemin-pngquant-cn");
const node_tinify_1 = require("node-tinify");
var COMPRESS_TYPE;
(function (COMPRESS_TYPE) {
    COMPRESS_TYPE["builtin"] = "builtin";
    COMPRESS_TYPE["tinypng"] = "tinypng";
})(COMPRESS_TYPE || (COMPRESS_TYPE = {}));
function compressImage(buffer, type) {
    if (!COMPRESS_TYPE[type]) {
        type = COMPRESS_TYPE.builtin;
    }
    switch (type) {
        case COMPRESS_TYPE.builtin:
            return imagemin(buffer, {
                plugins: [
                    imageminJpegtran(),
                    imageminPngquant({
                        quality: [0.6, 0.8]
                    })
                ]
            });
        case COMPRESS_TYPE.tinypng:
            return (0, node_tinify_1.compress)(buffer, { returnType: 'buffer' });
    }
}
exports.compressImage = compressImage;
//# sourceMappingURL=compress.js.map