module.exports = function() {
  var ele = document.createElement('video')
  ele.id = "remoteVideo"
  ele.autoplay = "autoplay"
  document.querySelector('.front').appendChild(ele)

  WebRTCAPI.init({
    onInitResult: function(result) {
      console.log("on init result : " + result);
      if (result !== 0) {
        var errorStr = "";
        if (result === -10001) {
          errorStr = "WebRTCJSAPI初始化参数不正确";
        } else if (result === -10002) {
          errorStr = "浏览器版本不正确";
        } else if (result === -10003) {
          errorStr = "sig校验失败";
        } else if (result === -10006) {
          errorStr = "WebSocket 初始化失败";
        } else {
          errorStr = "初始化错误";
        }
        console.log(errorStr);
      } else {
        //创建房间
        WebRTCAPI.createRoom({
          roomid: 59,
          role: 'LiveGuest'
        }, function(result) {
          console.log(result)
        });
      }
    },
    onLocalStreamAdd: function(e) {

    },
    onRemoteStreamAdd: function(stream, videoId) {
      console.log(stream, videoId)
      var videoElement = document.getElementById("remoteVideo");
      videoElement.srcObject = stream;
    },
    onRemoteStreamRemove: function(videoId) {
      var videoElement = document.getElementById(videoId)
      //特别注意，这里要把videoElement的srcObject置空
      videoElement.srcObject = null
      videoElement.parentNode.removeChild(videoElement)

    },
    onUpdateRemoteStream: function(stream, videoId, type, ssrState, openId) {
      this.onRemoteStreamAdd(stream, videoId, openId);
    },
    onKickout: function() {
      alert("其他地方登录，被T下线")
    },
    onWebSocketClose: function() {
      //断开后的处理
      WebRTCAPI.quit();
    },
    onRelayTimeout: function(e) {
      console.log(e)
    },
    onIceConnectionClose: function() {

    },
    onChangeRemoteStreamState: function() {

    }

  }, {
    openid: "1585",
    sdkAppId: 1400050371,
    accountType: 19242,
    closeLocalMedia: true,
    userSig: "eJxFkF1PgzAUQP8Lr5itLe1qTHyAjTEnIzFjXXxqyFrkbvIhtFNi-O8iYfH1nNzcc**3k8b7WdY0oGRmpNcq58FBzt2I9VcDrZZZbnQ7YMwYIwjd7FW3HdTVIAjCDBMPoX8JSlcGcpgG79nEO3gbwC48LJ8iteYHunG37D0-0nPpJoEV5TY4NpammzylHCI8Xy8TX-gQ*vZj8VlEzIW56M-7uCb8uuoRR4H-Ghf2IsLi2QY78ZLo7vG2TF3keNpfAx3iGPI4nqSBUo9teME54YROPDudalsZafpGj7-4*QXQ01T-",
  })
}