function zepto(s) {
  this.ele = document.querySelectorAll(s)
  this.length = this.ele.length
}

function each(callback) {
  this.forEach(function(item, index) {
    callback(item, index)
  })
}

zepto.prototype.show = function() {
  each.call(this.ele, function(item) {
    item.style.display = 'block'
  })
  return this.ele
}
zepto.prototype.hide = function() {
  each.call(this.ele, function(item) {
    item.style.display = 'none'
  })
  return this.ele
}

zepto.prototype.on = function(event, callback) {
  each.call(this.ele, function(item) {
    item.addEventListener(event, callback)
  })

  return this.ele
}

zepto.prototype.css = function(property, value) {
  each.call(this.ele, function(item) {
    item.style[property] = value
  })

  return this.ele
}


zepto.prototype.eq = function(index) {
  return this.ele[index]
}

zepto.prototype.height = function() {
  return this.style.height
}

window.$ = (selector) => {
  return new zepto(selector)
}

export default window.$