module.exports = function() {
  var ele = document.createElement('video')
  ele.id = "remoteVideo"
  ele.autoplay = "autoplay"
  document.querySelector('.front').appendChild(ele)

  WebRTCAPI.init({
    onInitResult: function(result) {
      console.log("on init result : " + result);
      if (result !== 0) {
        var errorStr = "";
        if (result === -10001) {
          errorStr = "WebRTCJSAPI初始化参数不正确";
        } else if (result === -10002) {
          errorStr = "浏览器版本不正确";
        } else if (result === -10003) {
          errorStr = "sig校验失败";
        } else if (result === -10006) {
          errorStr = "WebSocket 初始化失败";
        } else {
          errorStr = "初始化错误";
        }
        console.log(errorStr);
      } else {
        //创建房间
        WebRTCAPI.createRoom({
          roomid: RoomNumber,
          role: Role
        }, onCreateRoomCallback);
      }
    },
    onLocalStreamAdd: function(e) {

    },
    onRemoteStreamAdd: function(stream, videoId) {
      var videoElement = document.getElementById("remoteVideo");
      videoElement.srcObject = stream;
    },
    onRemoteStreamRemove: function(videoId) {
      var videoElement = document.getElementById(videoId)
      //特别注意，这里要把videoElement的srcObject置空
      videoElement.srcObject = null
      videoElement.parentNode.removeChild(videoElement)

    },
    onUpdateRemoteStream: function(stream, videoId, type, ssrState, openId) {
      var videoElement = document.getElementById(videoId);
      videoElement.parentNode.removeChild(videoElement)
      //这里调用remotestreamadd的回调函数
      onRemoteStreamAdd(stream, videoId, openId);
    },
    onKickout: function() {
      alert("其他地方登录，被T下线")
    },
    onWebSocketClose: function() {
      //断开后的处理
      WebRTCAPI.quit();
    },
    onRelayTimeout: function(e) {
      console.log(e)
    },
    onIceConnectionClose: function() {

    },
    onChangeRemoteStreamState: function() {

    }

  }, {
    openid: "1574",
    sdkAppId: 1400050371,
    accountType: 19242,
    userSig: "eJxFkFFPgzAUhf8LrzNyCytVEx-qYGQGE8fAZHtpKnTkOmEddAM0-neRjPh6vtyc79xvK4k2t1JrzIU0wq1z68EC62aMVaexVkLujaqHmFBKHYCJXlTd4LEagAOEEscF*IeYq8rgHsdDzjm9v4IGiyF5CdLFyk-t*LCLi26RaB9ksA6Lks1t8hSuGnnq4*VH28PsEpEy4xjw1t62Jf1iBN8*qyXwu-dot-UTrzinJx2Em3XCQxV3s*dX-jiV5Qcxbvuznw92FFxGrtBgqcZVxGOeS9lkKLPseK6MML1W4zN*fgGy2FYp",
  })
}