/**
 * @desc:
 * @author : Dec-F
 * @Date : 2018-07-31 15:13:36
 * @Last Modified by: miaokefu@duiba.com.cn
 * @Last Modified time: 2018-09-20 17:10:55
 */

/**
 * wxShare(opts) 
 * 
 * opts:{
 *    url:'' //当前页面url（不带hash）
 *    wxShareTitle: ‘’,   //标题
        wxShareSubTitle:‘’, // 副标题
        shareUrl: {//分享出去的url
          circle:'' //朋友圈
          friends:''  //好友
        },       
        wxShareImg: ‘’      //图片,
        success:function(res) {  //成功的回调   res.type=1:分享好友成功 =2 分享朋友圈成功
          
        }
 * }
 *
 *
 */
import * as wxsdk from '@js/wxsdk';

export const wxShare = opts => {
  // 微信url不能包含#hash后面部分
  wx.ready(() => {
    wxsdk.share({
      wxShareTitle: opts.wxShareTitle, //标题
      wxShareSubTitle: opts.wxShareSubTitle, // 副标题
      shareUrl: opts.shareUrl,
      wxShareImg: opts.wxShareImg, //图片,
      success: opts.success
    });
  });
  wxsdk
    .init({
      url: opts.url, //当前页面url（不带hash）
      jsApiList: ["chooseImage","uploadImage","downloadImage","getLocalImgData"], // 需要使用的JS接口列表 默认包含['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ']
      debug: false
    })
    .then(res => {
      console.log('wxinit', res);
    });
};

/**
 * 
 * wxImgUploade()
 * wx上传图片
 *
 *
 */
export const wxImgUploade = opts => {
  return new Promise((resove, reject)=>{
    let images = [];
    wxsdk
      .init({
        url: location.href.split('#')[0], //当前页面url（不带hash）
        jsApiList: ["chooseImage","uploadImage","downloadImage","getLocalImgData"], // 需要使用的JS接口列表 默认包含['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ']
        debug: false
      })
      .then(res => {
        wx.ready(() => {
          wxsdk.imageUploade(opts).then(data=>{
            images = data;
            console.log(data, "stepuuuuu");
            resove(images);
          });
        });
      });
  })
  
};
