import {getUrlParameter} from '@js/utils';
import qs from 'qs'; 
import axios from 'axios';
// import toast from '@components/toast/2.0.0';
import Promise from 'promise-polyfill';

axios.defaults.timeout = 10000; // 超时时间
// 根据环境设置baseUrl
// let baseUrl = '';
// if (process.env.NODE_ENV === 'development') {
//     baseUrl = '';
// } else if (process.env.NODE_ENV === 'production') {
//     baseUrl = '';
// }
// axios.defaults.baseURL = baseUrl;

// axios请求拦截
axios.interceptors.request.use(
    config => {
        // 统一拼上固定要传的参数
        let method = config.method;
        let baseParams = {
            sessionKey: getUrlParameter('sessionKey'),
            sourceToken: getUrlParameter('sourceToken'),
            sourceUserId: getUrlParameter('sourceUserId')
        }

        // 本地开发模拟用户
        if (getUrlParameter('debug')) {
            baseParams.sessionKey = 'nFgB9FwDLjiui2F86D8gJhzV8BDMBGkPLfzzLK6rB';
            baseParams.sourceToken = 'emyBj9UvCLx';
            baseParams.sourceUserId = '10831004';
        }
        // config.headers.base = baseParams;
        // if (method === 'get') {
            config.params = {...baseParams, ...config.params}
        // } else 
        if (method === 'post' && config.headers['content-type'] == 'application/x-www-form-urlencoded;charset=UTF-8'){
            // config.data = qs.stringify(config.data);
        } 
        return config;
    }, 
    error => {
        return Promise.error(error);
    }
);

// axios响应拦截
axios.interceptors.response.use(
    response => {
        if (response.status === 200) {
            return Promise.resolve(response);
        } else {
            return Promise.reject(response);
        }
    }
)

const handleReuslt = (res, resolve, reject) => {
    let {
        data,
        success,
        desc,
        code
    } = res.data;
    if (code == '0000000') {
        resolve(data);
    } else {
        console.error('服务端返回 code !== 0000000');
        console.error(res.data);
        reject(res.data);
    }  
}

export const get = (url, params, config)=> {
    return new Promise((resolve, reject)=>{
        axios({
            method:'get',
            url:url,
            params: params,
            paramsSerializer: function(params) {
               return qs.stringify(params, {arrayFormat: 'repeat'})
            },
            ...config
        }).then(res => {
            handleReuslt(res, resolve, reject);
        }).catch(err => {
            console.error(err);
            reject(err.data);
        });
    });
}

export const post = (url, params,config)=> {
    return new Promise((resolve, reject)=>{
        axios({
            method:'post',
            url:url,
            data: params,
            // headers: { 'content-type': 'application/x-www-form-urlencoded;charset=UTF-8' },
            headers: { 'content-type': 'application/json;charset=UTF-8' },
            ...config
        }).then(res => {
            handleReuslt(res, resolve, reject);
        }).catch(err => {
            console.error(err);
            reject(err.data);
        });
    });
}
