/*
 * @Author: miaokefu@duiba.com.cn 
 * @Date: 2018-08-13 13:32:44 
 * @Last Modified by: miaokefu@duiba.com.cn
 * @Last Modified time: 2018-09-20 16:42:19
 * @desc 公用的http后端请求
 */
import { getUrlParameter } from '@js/utils';
import { get, post } from '../http';

/**
 * 获取apk下载链接
 * @param {*} channel
 */
export const getDownloadUrl = channel =>
  get('/youtui/system/getDownloadUrl', {
    channelString: channel,
  });

/**
 * 获取微信初始化信息
 * @param {*} url  不带#后面部分
 */
export const getWxConfig = url =>
  get('/youtui/context/getWxConfig', {
    url: url,
    contentId: getUrlParameter('id'),
    contentType: getUrlParameter('type')
  });

/**
 * 获取app端内分享信息
 */
export const getAppShareInfo = (shareFrom = 1) =>
  get('/youtui/content/share', {
    contentId: getUrlParameter('id'),
    contentType: getUrlParameter('type'),
    shareFrom: shareFrom, // 固定为1 点击分享来源（0：app卡片；1：预览页）
  });

/**
 * 端外通用分享信息接口
 * @param {*} extParam 扩展参数
 */
export const getCommonShare = extParam =>
  get('/youtui/share/commonShareUrl', {
    contentId: getUrlParameter('id'),
    contentType: getUrlParameter('type'),
    consumerIdOrder: getUrlParameter('consumerIdOrder'),
    ...extParam,
  });

export const getLandAB = () => get('/youtui/ab/getLand');

/**
 * 上传图片
 * @param {*} data
 */
export const uploadPic = data =>
  post(
    '/upload/uploadPicByBase64',
    {
      picBase64: data,
    },
    {
      headers: { 'content-type': 'application/json;charset=UTF-8' },
    }
  );

/**
 * 获取短链
 * @param {String} url 原链接
 */
export const getShortLink = url => {
  let regexp = /^https?:\/\/(([a-zA-Z0-9_-])+(\.)?)*(:\d+)?((\/((\.)?(\?)?=?&?[a-zA-Z0-9_-](\?)?)*)*)$/i;
  let matchObj = regexp.exec(url);
  let path = matchObj ? matchObj[5] : url;
  return get('/qsaK/create', {
    path: encodeURIComponent(path), // url去除协议和域名部分
  });
};

/**
 * 上传音频
 * @param {*} data
 */
export const uploadAudio = data =>
  post(
    '/upload/uploadSoundByBase64',
    {
      picBase64: data,
    },
    {
      headers: { 'content-type': 'application/json;charset=UTF-8' },
    }
  );