
import {getUrlParameter} from '@js/utils';
import {get, post} from '../../http';


export const getIndex = (recordId) => get('/youtui/national/index', {
    img: getUrlParameter('img'),
    nickName: decodeURIComponent(getUrlParameter('nickName')) ,
    contentId: getUrlParameter('id'),
	consumerIdOrder: getUrlParameter('consumerIdOrder'),
	appPreview: getUrlParameter('appPreview'),
	recordId: recordId || getUrlParameter('recordId'),

});


export const getWxUserInfo = () => get('/youtui/national/getWxUserInfo', {
    
});

export const sendBless = ({
    userName, userImg, province, content, type,isSave , recordId
}) => get('/youtui/national/share', {
    recordId: recordId, // 当自己访问自己分享内容时，需要把上一次的分享内容带上
    userName: userName || 'vi',
    userImg: userImg || 'vi-pic',
    province: province, 
    content: content,
    type: type,
    contentId: getUrlParameter('id'),
	consumerIdOrder: getUrlParameter('consumerIdOrder'),
	appPreview: getUrlParameter('appPreview'),
	contentType: getUrlParameter('type'),
    saveSwitch: isSave // 是否保存记录
});

