/*
 * @Author: miaokefu@duiba.com.cn 
 * @Date: 2018-08-21 17:11:21 
 * @Last Modified by: Dec-F (fanxuehui@duiba.com.cn)
 * @desc 热文接口
 */
import {getUrlParameter} from '@js/utils';
import {get, post} from '../../http';

/**
 * 获取文章信息
 */
export const getArticleInfo = () => get('/youtui/hotText/info', {
    id: getUrlParameter('id'),
    appPreview: getUrlParameter('appPreview'),
    pageId: getUrlParameter('pageId')
});

/**
 * 获取评论
 */
export const getComment = () => get('/youtui/content/countComment', {
    contentId: getUrlParameter('id'),
    contentType: getUrlParameter('type'),
    start: 0
});

/**
 * 获取内容点赞数
 */
export const getStar = () => get('/youtui/content/countStar', {
    contentId: getUrlParameter('id'),
    contentType: getUrlParameter('type')
    
});

/**
 * 获取当前用户对指定分享内容的点赞状态
 */
export const getStarStatus = () => get('/youtui/content/starStatus', {
    contentId: getUrlParameter('id'),
    contentType: getUrlParameter('type')
});

/**
 * 内容评论
 * @param { } commentId 
 * @param {*} commentText 
 */
export const postComment = (commentText, commentId) => {
    let params = {
        contentId: getUrlParameter('id'),
        contentType: getUrlParameter('type'),
        commentId: commentId,
        commentText: commentText,    
    }
    if (!getUrlParameter('appPreview')) {
        params.shareUserId = getUrlParameter('sourceUserId');
    }
    return post('/youtui/content/comment', params);
}

/**
 * 内容点赞
 */
export const postStar = () => { 
    let params = {
        contentId: getUrlParameter('id'),
        contentType: getUrlParameter('type')
    };
    
    if (!getUrlParameter('appPreview')) {
        params.shareUserId = getUrlParameter('sourceUserId');
    }
    return post('/youtui/content/star', params);
};
  

/**
 * 顶通低通
 */
export const getBanners = () => get('/youtui/content/banners');


/**
 * 文章列表
 */
export const getAppArticleList = () => get('/youtui/content/appArticleList', {
    appPreview: getUrlParameter('appPreview'),
    contentIdOrder: getUrlParameter('contentIdOrder'),
    id: getUrlParameter('id')
});

/**
 * 看一看列表
 */
export const getH5ArticleList = () => get('/youtui/content/h5ArticleList',{
    contentIdOrder: getUrlParameter('contentIdOrder'),
    id: getUrlParameter('id')
});

/**
 * 编辑推荐
 */
export const getRecommends = () => get('/youtui/content/recommends', {
    contentIdOrder: getUrlParameter('contentIdOrder'),
    appPreview: getUrlParameter('appPreview'),
    id: getUrlParameter('id')
});

/**
 * 获取资源位
 */
export const getResource = () => get('/youtui/content/resource');

