/**
 * @note
 * @author  miaokefu <miaokefu@duiba.com.cn>
 * @create  2018-05-02
 * @des
 */
const path = require('path');
const testDomain = '//yun.dui88.com/';
const prodDomain = '//yun.duiba.com.cn/';
const cdnDir = 'h5-mami/webgame/';
const proxyServer = require('./proxy-server');
const http = require("./http");
console.log("http.server = " + http.server);

module.exports = {
  dev: {
    // Paths
    assetsSubDirectory: '',
    assetsPublicPath: '/',
    host: '127.0.0.1',
    port: 4000,
    devtool: '#cheap-module-eval-source-map',
    autoOpenBrowser: false,
    cssSourceMap: true,
    useEslint: false,
    showEslintErrorsInOverlay: false,
    // proxy: {
    //   '/mock': {
    //     target: http.server,
    //     pathRewrite: { '^/mock': '' },
    //     changeOrigin: true,
    //     secure: false
    //   }
    // },
  },

  build: {
    // Template for index.html
    index: path.resolve(__dirname, '../dist/index.html'),
    // Paths
    assetsRoot: path.resolve(__dirname, '../dist'),
    assetsSubDirectory: '',
    assetsPublicPath: process.env.NODE_ENV === 'production' ? `${prodDomain + cdnDir}` : `${testDomain + cdnDir}`,
    // assetsPublicPath: '',
    cdnDir: cdnDir,
    /**
     * Source Maps
     */
    productionSourceMap: false,
    // https://webpack.js.org/configuration/devtool/#production
    devtool: '#source-map',

    uglifyConfig: {
      compress: {
        warnings: false,
        drop_debugger: true,
        drop_console: process.env.NODE_ENV === 'production' ? true : false
      }
    }
  }
};
