/*
 * @Author: miaokefu@duiba.com.cn 
 * @Date: 2018-08-13 14:06:04 
 * @Last Modified by: miaokefu@duiba.com.cn
 * @Last Modified time: 2018-10-26 12:46:42
 * @desc 统一埋点接口
 */
import { parseUrlParams, deleteInvalidKey} from '@js/utils';
import axios from 'axios';

let urlParams = parseUrlParams();
let {
    sessionKey,
    sourceToken,
    sourceUserId,
    consumerIdOrder, 
    appPreview, 
    share_way,
    shareContentIndex,
    isPic,
    version,
    contentIdOrder
} = urlParams;

let contentId = urlParams.id;
let contentType = urlParams.type;

/**
 * 用户行为埋点
 * @param {Number} type 埋点类型
 * @param {Object} data 特殊字段对象
 * @desc  type = 801时需要传入当前分享信息的shareContentIndex和share_way，而不是url上的shareContentIndex和share_way，统计当前分享文案以及分享渠道对回访的影响
 *
 */
const track = (type, data) => {
    if (type === undefined || type === null) {
        console.error('埋点值不能为空');
    }
    // type为1需要传入整个url参数纪录访问
    // 08.22 所有埋点统一拼上urlQuery，不再区分type为1的情况
    // if (type === 1) {
        data = Object.assign({}, data, { urlQuery: urlParams })
    // }
    return axios({
        method: 'get',
        url: '/youtui/log/embedContentLogs',
        params: deleteInvalidKey({
            type: type,
            sessionKey: sessionKey,
            sourceToken: sourceToken,
            sourceUserId: sourceUserId,
            contentId: contentId, // 内容id
            contentType: contentType, // 内容类型
            consumerIdOrder: consumerIdOrder,
            appPreview: appPreview,
            share_way: share_way,
            shareContentIndex: shareContentIndex, // 分享标题文案分流用的
            isPic: isPic,
            version: version,
            // content_id_order: contentIdOrder || 1,
            ...data
        }),
        timeout: 3000,

    });
}

export default track;
