const Template = require('@lib/lib-template/4.0.0/artTemplate');
export const compileRender = function (data, tpl, el, type) {
  if (data) {
    var render = Template.compile(tpl);
    var html = render(data);
    type && type === 'append' ? el.append(html) : el.html(html);
  }
};

export function templateImports() {

  Template.defaults.imports.orderStatusSubHeader = function (value) {
      switch (value) {
          case "processing":
              return '积分正在扣取，请耐心等待';
          case "wait_pay":
              return `<span class="left_time">还剩<span id="close_time"></span>订单将自动关闭</span>`;
          case "delivery":
              return `还剩<span id="confirm_receipt_time"></span>交易将自动确认完成`;
          default:
              return '';
      }
  };   

}