require('./index.less');
import { getGameList } from '@apis/game/farm';
import { goApp } from '../util';
import { formatUrl } from '@js/utils';

export default function init(ele, showButton, opts) {
  let tpl = require('./index.html');
  let _opts = opts;
  let _showButton = showButton;
  let isShow = false;
  function render() {
    $(ele).append(tpl);

    if (showButton) {
      $(opts.content)
        .find('.game-reflux-list')
        .addClass('game-reflux-list-extend');
    }
    createList(ele).then(() => {
      bindEvent();
    });

    $(opts.content)
      .siblings()
      .hide();
  }
  function show(type) {
    hide();
    if (type == 3) {
      _opts.__track('holdback_expose');
    } else {
      _opts.__track('moregame_expose');
    }
    _opts.__track('download_show');
    isShow = true;
    $(opts.content)
      .find('.game-reflux-list')
      .show();
    $(opts.content)
      .siblings()
      .show();
  }
  function hide() {
    $('.game-reflux-list').hide();
    $('.game-reflux-mask').hide();
    isShow = false;
  }
  function bindEvent() {
    $('.game-reflux-list-close').on('click', function() {
      hide();
    });
    $('.game-reflux-game-button').on('click', function() {
      if (!isShow) {
        return;
      }
      if ($(this).hasClass('game-reflux-go') && $(this).data('go')) {
        if (_showButton) {
          _opts.__track('holdback_play');
        } else {
          _opts.__track('moregame_play');
        }
        setTimeout(() => {
          location.href = formatUrl($(this).data('go'), { isGameReflex: 1 });
        }, 200);
      } else {
        if (_showButton) {
          _opts.__track('holdback_download');
        } else {
          _opts.__track('moregame_download');
        }
        goApp(_opts.appLink);
      }
    });
    $('.game-reflux-mask').on('click', function(e) {
      var _con = $('.game-reflux-list');
      console.log(!$(e.target).is('.game-reflux-list'), _con.has(e.target).length === 0, 12, e.target);
      if (!$(e.target).is('.game-reflux-list') && _con.has(e.target).length === 0) {
        hide();
      }
    });
  }

  function createList(ele) {
    return getGameList()
      .then(data => {
        return (
          data &&
          data.reduce((acc, game) => {
            return (acc += `
    <div class="game-reflux-list-item">
      <div class="game-reflux-game-icon">
          <img src="${game.imgUrl}" />
      </div>
      <div class="game-reflux-game-info">
        <div class="game-reflux-game-name">${game.contentName}</div>
        <div class="game-reflux-game-desc">${game.contentDesc}</div>
      </div>
      <div class="game-reflux-game-button ${game.outside ? 'game-reflux-go' : ''}" data-go="${game.playUrl}">
        <span class="game-reflux-button-text">${game.outside ? '立即开玩' : '立即开玩'}</span>
        <span class="game-reflux-button-icon"></span>
      </div>
    </div>`);
          }, '')
        );
      })
      .then(tpl => {
        $(ele)
          .find('.game-reflux-list-body')
          .html(tpl);
      });
  }
  return {
    render,
    show
  };
}
