
import {getUrlParameter} from '@js/utils';
import {get, post} from '../../http';
import {getStorage} from "@common/js/utils"

/**
 * 获取配置信息
 * @param {*} resultStatus  参与状态,0 未参与 1 参与
 * @param {*} isPic 是否为二维码链接
 */
export const getIndex = ( resultStatus, isPic) => get('/userKeyWord/index', {
	id: getUrlParameter('id'),
	consumerIdOrder: getUrlParameter('consumerIdOrder'),
	appPreview: getUrlParameter('appPreview') || 0,
	isPic :isPic || '',
	resultStatus: resultStatus
});

export const doJoin = () => get('/userKeyWord/doJoin', {
	id: getUrlParameter('id'),
	appPreview: getUrlParameter('appPreview'),
	consumerIdOrder: getUrlParameter('consumerIdOrder')
});

export const getShareInfo = (resultStatus) => get('/userKeyWord/share', {
	contentId: getUrlParameter('id'),
	contentType: getUrlParameter('type'),
	consumerIdOrder: getUrlParameter('consumerIdOrder'),
	resultStatus: resultStatus
});