import init from '../components/game-list/index';
import { interceptBack } from '../components/util';

module.exports = opts => {
  var list = init($('.game-reflux-content.game-reflux-type3')[0], true, opts);
  $('.game-reflux-content.game-reflux-type1 .game-reflux-list').hide();
  list.render();
  $('.game-reflux-list-button-group').on('click', 'div', function() {
    if ($(this).hasClass('button-leave')) {
      window.history.back();
      $('body').trigger('leave-click', {
        type: $(this)
          .closest('.game-reflux-content')
          .data('type')
      });
    } else {
      $('body').trigger('continue-click', {
        type: $(this)
          .closest('.game-reflux-content')
          .data('type')
      });
    }
    $('.game-reflux-list-close').triggerHandler('click');
  });
  interceptBack(() => {
    if (!checkFlag()) {
      list.show(3);
    }
  });
};

function checkFlag() {
  let flag = sessionStorage.getItem('game_reflux_has_intercept');
  if (flag) {
    window.history.back();
  } else {
    sessionStorage.setItem('game_reflux_has_intercept', true);
  }
  return flag;
}
