/*
 * @Author: miaokefu@duiba.com.cn 
 * @Date: 2018-08-30 11:58:43 
 * @desc 金币派送
 */ 

import {getUrlParameter} from '@js/utils';
import {get, post} from '../../http';

export const getIndex = () => get('/goldSend/index');

/**
 *  参与 
 * @param {*} amount 
 * @param {*} actNum 活动编号 1 10点活动 2 20点活动
 */
export const doJoin = (amount,actNum ) => get('/goldSend/doJoin' , {
    amount: amount,
    actNum: actNum
});

/**
 * 完成
 * @param {*} actNum 活动编号 1 10点活动 2 20点活动
 */
export const finish = (actNum) => get('/goldSend/finish', {
    actNum: actNum
});

/**
 * 获取游戏结果的金币数量
 * @param {*} actNum 活动编号 1 10点活动 2 20点活动
 */
export const result = (actNum) => get('/goldSend/result', {
    actNum: actNum
});

/**
 * 开始游戏
 * @param {*} actNum 活动编号 1 10点活动 2 20点活动
 */
export const start = (actNum) => get('/goldSend/start', {
    actNum: actNum
});

/**
 * 获取分享信息
 * @param {*} actNum 活动编号 1 10点活动 2 20点活动
 */
export const getShareInfo = (actNum) => get('/goldSend/share', {
    id: getUrlParameter('id'),
    actNum: actNum
});

/**
 * 获取参与人数
 */
export const personCount = () => get('/goldSend/personCount');

/**
 * 好友助力
 */
export const boost = () => get('/goldSend/boost', {
    joinTime: getUrlParameter('joinTime'),
    actNum: getUrlParameter('actNum'),
    sourceId: getUrlParameter('sourceId')
});

/**
 * 好友助力2
 */
export const boost2 = (actNum) => get('/goldSend/boost2', {
    id: getUrlParameter('id'),
    actNum: actNum
});



