require('./dui-toast.js');
let Zepto = require('../zepto/1.1.4/index');
;
(function($) {
  var defaults = {
    type: 'alert',    // 类型
    content: '提示',      //内容
    hideTime: 1000,
    callback: function() {}
  };


  var Toast = function(options) {
    this.options = $.extend({}, defaults, options);
    this.init();
  };

  Toast.prototype = {
    constructor: Toast,
    init: function() {
      this.renderTemp();
    },
    renderTemp: function() {
      var self = this;
      if ($('.dui-toast').length) return;
      var _template = `<div class="dui-toast">`;

      if (self.options.type !== 'alert') {
        var _icon = '';
        switch(self.options.type) {
          case 'success':
            _icon = 'dui-icon-toast-chenggong';
            break;
          case 'error':
            _icon = 'dui-icon-toast-shibai';
            break;
          case 'warn':
             _icon = 'dui-icon-toast-zhuyi';
            break;
        }
        _template += `<div class="dui-toast__icon"><i class="dui-icon-handle ${_icon}"></i></div>`;
      }

      _template += `
        <div class="dui-toast__content">
          ${this.options.content}
        </div>
      </div>`;
      $('body').append(_template);
      this.close();
    },
    close: function() {
      var self = this;
      setTimeout(function() {
        $('.dui-toast').length && $('.dui-toast').remove();
        self.options.callback && self.options.callback();
      }, self.options.hideTime);
    }
  };

  $.toast = function(options) {
    var toast = new Toast(options);
    return toast;
  };

})(Zepto);
