
import {getUrlParameter} from '@js/utils';
import {get, post} from '../../http';

/**
 * 获取页面初始化信息
 * @param isPic 是否从二维码进入
 * 页面类型 0：占卜页面；1：分享者-结果页面 2：自己-结果页面 ,
 */
export const getIndex = (tender) => get('/youtui/yanxi/index', {
   id: getUrlParameter('id'),
   consumerIdOrder: getUrlParameter('consumerIdOrder'),
   tender
});


export const getList = () => get('/youtui/yanxi/getQuestionList', {});

export const getResult = (answer, tender) => get('/youtui/yanxi/getYanxiResult', {
	answer: encodeURI(answer),
	tender
});

export const getWxShareUrl = (type) => get('/youtui/share/getYanxiShareUrl', {
	type: type,
	id: getUrlParameter('id'),
	consumerIdOrder: getUrlParameter('consumerIdOrder')
});

export const getDownloadUrl = () => get('/youtui/system/getDownloadUrl', {
	channelString: "yysc-cc-a-yxgl-97-2"
});

