/*
 * @Author: Zhang Min
 * @Date: 2018-05-14 14:41:49
 * @Last Modified by: miaokefu@duiba.com.cn
 * @Last Modified time: 2018-08-16 16:57:20
 */

/**
 * 预加载图片
 * 1.调用 preload(image, useWebp)
 * 2.image 图片路径数组／图片路径名称
 * 3.seWebp 预加载是否使用webp优化。默认为true，除外：预加载css中图片素材，不开启webp优化
 */
const preload = (images, useWebp = true) => {
    const load = (image, _i, useWebp) => {
      _i = new Image();
      if (useWebp && typeof ''.ossimg === 'function') {
        image = image.ossimg();
      };
      _i.src = image;
      _i.onload = _i.onerror = function() {
        _i.onload = _i.onerror = null;
        _i = null;
      };
    };
  
    if (typeof images === 'string') {
      let _image;
      load(images, _image, useWebp);
    } else {
      let _imageArr = [];
      images.forEach((image, i) => {
        load(image, _imageArr[i], useWebp);
      });
    }
  };
  module.exports = preload;
  