/**
 * 微信初始化
 * opts:{
 *    url:'' //当前页面url（不带hash）
      jsApiList: [] // 需要使用的JS接口列表 默认包含['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ', 'hideMenuItems']
      debug:false // 是否开启调试
 * }
 * @param {*} opts 
 */
import axios from "axios";
import { getWxConfig } from '@apis/common';
import { formatUrl, arrayUnique, isAndroid} from '@js/utils';

export const init = opts => {
    console.log('step3')
    let baseJsApis = ['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ', 'hideMenuItems'];
    let _defaultOpts = {
      jsApiList: [],
      debug: false,
      url: location.href.split('#')[0]
    };

    let options = Object.assign({}, _defaultOpts, opts)
    // 微信url不能包含#hash后面部分
    return getWxConfig(options.url.split('#')[0])
      .then(res => {
        console.log(options, '===>opt', res);
        wx.config({
          debug: options.debug,
          appId: res.appId,
          timestamp: res.timeStamp,
          nonceStr: res.nonceStr,
          signature: res.signature,
          jsApiList: arrayUnique([...baseJsApis, ...options.jsApiList]),
        });
        
        wx.ready(()=>{
          // 微信中统一处理逻辑
          /***隐藏分享菜单****/
          wx.hideMenuItems({
            menuList: [
              'menuItem:share:qq',
              'menuItem:share:QZone'
            ] // 要隐藏的菜单项，只能隐藏“传播类”和“保护类”按钮
          });

        });
       
        wx.error(function(res) {
          alert(JSON.stringify(res));
          // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
        });
        
        return res;
    })
    .catch(err => {
      console.log('transferToAccount error');
    });
};

/**
 * share(opts) 
 * 
 * opts:{
 *      wxShareTitle: ‘’,   //标题
        wxShareSubTitle:‘’, // 副标题
        shareUrl: {//分享出去的url
          circle:'' //朋友圈
          friends:''  //好友
        },       
        wxShareImg: ‘’      //图片,
        success:function(res) {  //成功的回调   res.type=1:分享好友成功 =2 分享朋友圈成功
          
        }
 * }
 * @param {*} opts 
 */
export const share = (opts) => {
  let shareData = {
    title: opts.wxShareTitle,
    desc: opts.wxShareSubTitle,
    //                link: '//' + window.location.host + '/youtui/consumer/share?id=30&type=2&sourceToken=&sessionKey=&pageShareType=3',
    // 必须带上协议，否则微信无法识别
    imgUrl: opts.wxShareImg,
  };

  let friendsShareData = Object.assign({}, shareData, {
    link: formatUrl(opts.shareUrl.friends, {
      share_way: 2,
    }),
    success: function() {
      try {
        opts.success({
          type: 1,
        });
      } catch (err) {
        console.error(err);
      }
    },
  });
  let circleShareData = Object.assign({}, shareData, {
    link: formatUrl(opts.shareUrl.circle, {
      share_way: 1,
    }),
    success: function() {
      try {
        opts.success({
          type: 2,
        });
      } catch (err) {
        console.error(err);
      }
    },
  });
  console.log(friendsShareData, circleShareData, '=====>sharedata');

  wx.ready((()=>{
     // 分享给朋友
      wx.onMenuShareAppMessage(friendsShareData);
      // 分享到朋友圈
      wx.onMenuShareTimeline(circleShareData);
      wx.onMenuShareQQ(shareData);
  }));
 
};

export const imageUploade = (opts) => {
  return new Promise((resove, reject)=>{
    var images = {           
     localId: [],            
     serverId: []
    };
    wx.ready(()=>{
      wx.chooseImage({
        sizeType: ['compressed'], // 可以指定是原图还是压缩图，默认二者都有
        sourceType: ['album'], // 可以指定来源是相册还是相机，默认二者都有        
        success: function(res) {
          if(opts.loading) {
            opts.loading();
          }                
          images.localId = res.localIds;
          var i = 0, length = images.localId.length;
          function upload() {
            wx.uploadImage({
              isShowProgressTips: 0,                  
              localId: images.localId[i],
              success: function(res) {
                var serverId = res.serverId                    
                images.serverId.push(serverId);
                console.log(images, "step2");
                //图片上传完成之后，进行图片的下载，图片上传完成之后会返回一个在腾讯服务器的存放的图片的ID--->serverId
                i++;
                if(i >= length) {
                  resove(images);
                }else {
                  upload();
                }
              }
            });
          }
          upload();      
        },
        cancel: function(res) {
          if(opts.close) {
            opts.close();
          }
        },           
        fail: function(res) {                                
          // alert(JSON.stringify(res));
          opts.close();
          console.log("err微信报错", res)                          
        }                        
      });
    });
    wx.error(function(res) {
      console.log("err微信报错", res);
      opts.close();
      // alert(JSON.stringify(res));
      // config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
    });
  })
}

