import { getUrlParameter } from '@js/utils';
import { get, post } from '../../http';


export const saveImage = (opts) => post('/youtui/album/save', {
    imgUrls: opts.imgUrls,
    bgmId: parseInt(opts.bgmId,10),
    templateId: parseInt(opts.templateId, 10),
    appPreview: getUrlParameter("appPreview")
});

export const getHistoryList = (opts) => get('/youtui/album/list', {
    currentPage: parseInt(opts.currentPage,10),
    pageSize: 10,
    appPreview: getUrlParameter("appPreview")
});

export const getDetail = (opts) => get('/youtui/album/detail', {
    albumId: parseInt(opts.albumId,10),
    appPreview: getUrlParameter("appPreview")
});

export const getIndex = (opts) => get('/youtui/album/index', {
    contentId: getUrlParameter("id"),
    appPreview: getUrlParameter("appPreview"),
    consumerIdOrder: getUrlParameter("consumerIdOrder"),
    recordId: getUrlParameter("recordId")
});


export const getShare = (opts) => get('/youtui/album/share', {
    contentId: getUrlParameter("id"),
    appPreview: getUrlParameter("appPreview"),
    consumerIdOrder: getUrlParameter("consumerIdOrder"),
    headImgUrl: opts.headImgUrl || getUrlParameter("headImgUrl"),
    nickName: opts.nickName || getUrlParameter("nickName"),
    recordId: getUrlParameter("recordId"),
    contentType: getUrlParameter("type"),
    sourceUserId: getUrlParameter("sourceUserId"),
    albumId: opts.albumId,
    saveSwitch: opts.saveSwitch
});


export const wxUpload = (opts) => post('/youtui/album/download', {
    mediaIds: opts.mediaIds
});