/**
 * @note
 * @author  miaokefu <miaokefu@duiba.com.cn>
 * @create  2018-05-02
 * @des
 */
const merge = require("webpack-merge");
const webpack = require("webpack");
const path = require("path");
const FriendlyErrorsPlugin = require("friendly-errors-webpack-plugin");
const UglifyJsPlugin = require('uglifyjs-webpack-plugin');
const baseWebpackConfig = require("./webpack.base.conf");
const utils = require("./utils");
const config = require("../config");
const entry = require("../config/entry");
const http = require("../config/http");

const host = utils.getHost();
const port = utils.getPort();

function resolve(dir) {
  return path.join(__dirname, dir);
}

Object.keys(baseWebpackConfig.entry).forEach(function(name) {
  if (name !== 'vendor') {
    baseWebpackConfig.entry[name] = baseWebpackConfig.entry[name].concat('webpack-hot-middleware/client?reload=true');
  }
});

const devWebpackConfig = merge(baseWebpackConfig, {
  // Provides process.env.NODE_ENV with value development. Enables NamedChunksPlugin and NamedModulesPlugin.
  mode: 'development',
  output: {
    publicPath: config.dev.assetsPublicPath
  },
  module: {
    rules: utils.styleLoaders({
      sourceMap: config.build.cssSourceMap,
      usePostCSS: true
    })
  },
  devtool: config.build.devtool,
  optimization: {
    // minimize: false,
    minimizer: [
      new UglifyJsPlugin({
        uglifyOptions: config.build.uglifyConfig
      })
    ],
    // 分割代码块
    splitChunks: {
      chunks: 'async',
      minSize: 30000,
      minChunks: 1,
      maxAsyncRequests: 5,
      maxInitialRequests: 3,
      name: true,
      cacheGroups: {
        // common: {
        //   name: "common",
        //   chunks: "all",
        //   // minSize: 1,
        //   priority: 0
        // },
        // vendor: {
        //   name: "vendor",
        //   test: /[\\/]node_modules[\\/]/,
        //   chunks: "all",
        //   priority: 10
        // }
      }
    }
    // runtimeChunk: true
  },
  plugins: [
    new webpack.DefinePlugin({
      HTTP: http.dev.HTTP,
      MOCK: http.dev.MOCK,
      PROXY: http.dev.PROXY
    }),
    new webpack.HotModuleReplacementPlugin(),
    new webpack.NoEmitOnErrorsPlugin(), // 启用此插件后，webpack 进程遇到错误代码将不会退出
    new FriendlyErrorsPlugin({
      compilationSuccessInfo: {
        messages: [`Your application is running here: http://${host}:${port}`],
        notes: ['Some additionnal notes to be displayed unpon successful compilation']
      },
      // should the console be cleared between each compilation?
      // default is true
      clearConsole: true
    }),
    // new webpack.ProvidePlugin({
    //   _: "underscore"
    // })
  ].concat(utils.computeHtmlWebpackEntry(entry))
});


module.exports = devWebpackConfig;
