import { get } from "@js/request";
import { parseUrlParams, formatUrl } from '@js/tooler'

const API = {
    getOaJssdk: '/kjy/mp/seller/getOaJssdk',
    getScId: '/kjy/mp/seller/getScId'
}

let config = {};

function updateLink(contentId){
    get(API.getScId, {
        contentId: contentId,
        showCard: 0
    }).then(res => {
        var obj = parseUrlParams();
        obj.scid = res.data;
        config.link = formatUrl(window.location.href.split("?")[0], obj);
        console.log(config.link);
    })
}

function shareConfig(obj){
    // alert(JSON.stringify(config));
    let {title, desc, img, debug} = obj;
    config = obj;

    get(API.getOaJssdk, {
        url: window.location.href.split("#")[0]
    }).then(res => {
        if(res.success){
            var data = res.data;
            wx.config({
                debug: !!debug,//生产环境需要关闭debug模式
                appId: data.appid,//appId通过微信服务号后台查看
                timestamp: data.timestamp,//生成签名的时间戳
                nonceStr: data.noncestr,//生成签名的随机字符串
                signature: data.sign,//签名
                jsApiList: [//需要调用的JS接口列表
                    'checkJsApi',//判断当前客户端版本是否支持指定JS接口
                    'onMenuShareTimeline',//分享给好友
                    'onMenuShareAppMessage'//分享到朋友圈
                ]
            });
        }
            
    })
    wx.ready(function () {
        //分享朋友圈
        wx.onMenuShareTimeline({
            title: title,
            link: config.link,
            imgUrl: img,
            success: function (res) {
                
            },
            cancel: function (res) {
                
            },
            fail: function (res) {
                
            }
        });
        //分享给好友
        wx.onMenuShareAppMessage({
            title: title, // 分享标题
            desc: desc, // 分享描述
            link: config.link, // 分享链接，该链接域名或路径必须与当前页面对应的公众号JS安全域名一致
            imgUrl: img, // 自定义图标
            type: 'link', // 分享类型,music、video或link，不填默认为link
            dataUrl: '', // 如果type是music或video，则要提供数据链接，默认为空
            success: function (res) {
                
            },
            cancel: function (res) {
                
            },
            fail: function (res) {
                
            }
        });
       
    });
}

export {
    shareConfig,
    updateLink
}
