const path = require('path');
const resolve = require('@rollup/plugin-node-resolve').default;
// const ts = require('rollup-plugin-typescript2');
const json = require('@rollup/plugin-json');
const commonjs = require('@rollup/plugin-commonjs');
const { terser } = require('rollup-plugin-terser');
// const postcss = require('rollup-plugin-postcss');

const pkg = require(path.resolve('./package.json'));

const name = pkg.name.replace('@credits/', '');
const config = {
  input: path.resolve(`./lib/${name}.js`),
  output: [
    {
      file: path.resolve(`./dist/${name}.min.js`),
      format: 'umd',
      name: name
    },
    {
      file: path.resolve(`./dist/${name}.es.js`),
      format: 'es'
    },
    {
      file: path.resolve(`./dist/${name}.cjs.js`),
      format: 'cjs'
    }
  ],
  plugins: [
    // postcss({
    //   extensions: ['.css']
    // }),
    resolve({ extensions: ['ts', 'js'] }),
    // ts({ tsconfig: path.resolve('./tsconfig.json') }),
    commonjs(),
    json(),
    process.env.NODE_ENV === 'production' && terser()
  ]
};

module.exports = config;
