const OSS = require("ali-oss");
// node
const fs = require("fs");
const path = require("path");

const env = "test";

const OSS_CONFIG = {
  test: {
    region: "oss-cn-beijing",
    accessKeyId: "LTAI5tB6oLJpKNy13BaAYKFU",
    accessKeySecret: "zkPB2UafA99ETMrb3akj7k257jXMvI",
    bucket: "wildwood-test",
    timeout: 300000
  },
  production: {
    region: "oss-cn-zhangjiakou",
    accessKeyId: "LTAI5t8EfV9aPMf8v7jUEmHn",
    accessKeySecret: "AlH3aRbbgSeOPtlulLmuBFn7qS9Xo9",
    bucket: "wildwood-prod",
    timeout: 300000
  },
};

const CDN = {
  test: "https://tmall-static-test.nike.com.cn",
  production: "https://tmall-static-test.nike.com.cn",
};

// 收集所有的文件路径
const arr = [];
let timer = null;
const ignoreFile = [".ds_store"];

// 初始化客户端
const client = new OSS(OSS_CONFIG[env]);

function computeTime(timestampDiff) {
  let computeTime = timestampDiff / 1000;
  let year = Math.floor(computeTime / 86400 / 365);
  computeTime = computeTime % (86400 * 365);
  let month = Math.floor(computeTime / 86400 / 30);
  computeTime = computeTime % (86400 * 30);
  let day = Math.floor(computeTime / 86400);
  computeTime = computeTime % 86400;
  let hour = Math.floor(computeTime / 3600);
  computeTime = computeTime % 3600;
  let minute = Math.floor(computeTime / 60);
  computeTime = computeTime % 60;
  let second = computeTime;
  return (
    year +
    "年" +
    month +
    "月" +
    day +
    "日" +
    hour +
    "时" +
    minute +
    "分" +
    second +
    "秒"
  );
}

const fileDisplay = (url, cb, prefix = url) => {
  const filePath = path.resolve(url);
  //根据文件路径读取文件，返回文件列表
  fs.readdir(filePath, (err, files) => {
    if (err) return console.error("Error:(spec)", err);
    files.forEach((filename) => {
      //获取当前文件的绝对路径
      const filedir = path.join(filePath, filename);
      // fs.stat(path)执行后，会将stats类的实例返回给其回调函数。
      fs.stat(filedir, (eror, stats) => {
        if (eror) return console.error("Error:(spec)", err);
        // 是否是文件
        const isFile = stats.isFile();
        // 是否是文件夹
        const isDir = stats.isDirectory();
        if (isFile && !ignoreFile.includes(filename.toLocaleLowerCase())) {
          arr.push(filedir.replace(path.resolve(__dirname, prefix), ""));
          // 最后打印的就是完整的文件路径了
          if (timer) clearTimeout(timer);
          timer = setTimeout(() => cb && cb(arr), 200);
        }
        // 如果是文件夹
        if (isDir) fileDisplay(filedir, cb, prefix);
      });
    });
  });
};

const upload = async (list, uploadPath, index) => {
  try {
    const res = await Promise.all(
      list.map((i) => {
        // console.log(`开始上传: ${CDN[env]}${uploadPath + i}`);
        return client.put(uploadPath + i, path.join(__dirname, "assets", i));
      })
    );
    console.log(
      `==${index}===上传成功总数:${res.length}=====文件总数:${
        list.length
      }======数量校验: ${res.length == list.length}===`
    );
    return true;
  } catch (error) {
    console.log(`${index}:`, JSON.stringify(error));
    return false;
  }
};

const MAX_UPLOAD_COUNT = 20;
const UPLOAD_PATH = "/avatar/d11";

const genUploadTask = async (totalList = [], startIndex = 0) => {
  // 如果是最后一队 结束索引为最后的index+1 否则按最大上传数加上当前开始索引
  const endIndex =
    startIndex + MAX_UPLOAD_COUNT > totalList.length
      ? totalList.length
      : startIndex + MAX_UPLOAD_COUNT;
  const res = await upload(
    totalList.slice(startIndex, endIndex),
    UPLOAD_PATH,
    endIndex
  );
  if (!res) return false;
  // 最后一队
  if (endIndex == totalList.length) return true;
  return await genUploadTask(totalList, endIndex);
};

fileDisplay("./assets/", async (list = []) => {
  let startTime = new Date().getTime();
  const result = await genUploadTask(list, 0);
  const diffTime = computeTime(new Date().getTime() - startTime);
  console.log("耗时:", diffTime);
  if (result) {
    console.log("上传结束！！！");
  } else {
    console.log("上传出错！！！");
  }
});
