// 压缩文件夹下所有模型
// 全局安装gltf-pipeline和gltfpack
// 处理前修改好模型名称
const fs = require("fs");
const fsExtra = require('fs-extra')
const exec = require('child_process').exec;
const args = process.argv.slice(2);
// 取得文件夹路径
const path = args[0] || "./sourceModel"

// 创建文件夹
createFinder(`${path}/compressed`)

var filenames = fs.readdirSync(path)
filenames = filenames.filter((name)=>{
  return (
    name.split(".")[1] === "gltf" && 
    name.split(".")[0].indexOf("-processed")<0 && 
    name.split(".")[0].indexOf("-pack")<0
  )
})

compress(filenames)

async function compress(filenames){
  for(let i=0;i<filenames.length;i++){
    let name = filenames[i].split(".")[0]
    console.log(`开始拆分模型：${name}.gltf`);
    await execAsync(`gltf-pipeline -i ${path}/${name}.gltf -o ${path}/compressed/${name}-processed.gltf -s`)
    console.log(`开始压缩模型：${name}-processed.gltf`);
    await execAsync(`gltfpack -i ${path}/compressed/${name}-processed.gltf -o ${path}/compressed/${name}-pack.gltf -cc`)
    console.log(`压缩模型完成：${name}-pack.gltf`);

    // 删除中间生产的processed模型
    fs.unlinkSync(`${path}/compressed/${name}-processed.gltf`)
    fs.unlinkSync(`${path}/compressed/${name}-processed.bin`)

    fsExtra.copySync(`${path}/compressed`, './assets/model')
  }
}
async function execAsync(cammand){
  return new Promise((r,j)=>{
    exec(cammand,{encoding: 'utf8'},(e)=>{
      r(e)
    })
  })
}

async function createFinder(dist){
  return new Promise((r,j)=>{
    fs.access(dist, function(err){
      if(err){
        // 目录不存在时创建目录
        fs.mkdirSync(dist);
      }
      r()
    });
  })
}

