package cn.com.duiba.udf;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by clemac on 17/2/16.
 */
public class TimeDiff extends UDF {

    public Long evaluate(String sTimes, String eTimes, String type){
        try {
            if(StringUtils.isBlank(sTimes) || StringUtils.isBlank(eTimes) || StringUtils.isBlank(type)){
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date sdate = sdf.parse(sTimes);
            Date edate = sdf.parse(eTimes);
            long from = sdate.getTime();
            long to = edate.getTime();

            if (to - from < 0){
                return null;
            }

            if("ss".equals(type)){
                return (to - from)/(1000);
            }

            if("mm".equals(type)){
                return (to - from)/(1000 * 60);
            }

            if("hh".equals(type)){
                return (to - from)/(1000 * 60 * 60);
            }

            if("dd".equals(type)){
                return (to - from)/(1000 * 60 * 60 * 24);
            }
            return null;
        } catch (Exception e) {
            return null;
        }
    }

}