package cn.com.duiba.udf;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 字符串求差值
 */

public class StringUnionUDF extends UDF{
    public String evaluate(String stra, String strb, String delimiter) {
        if (StringUtils.isBlank(stra)) {
            return strb;
        }
        if (StringUtils.isBlank(strb)) {
            return stra;
        }

        if (StringUtils.isBlank(delimiter)) {
            return null;
        }

        List<String> listA = Lists.newArrayList(StringUtils.split(stra, delimiter));
        List<String> listB = Lists.newArrayList(StringUtils.split(strb, delimiter));

        Set<String> set = new HashSet<>();
        //用set的特性去做
        set.addAll(listA);
        set.addAll(listB);
        return StringUtils.join(set, delimiter);
    }

}
