package cn.com.duiba.udf;

import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;


import java.util.*;

/**
 * 获取B中key在A里面的value
 */
public class AvailVectorUDF extends UDF {

    /**
     * @param strA      1,2,3,4
     * @param strB      1:2,3,4|2:2,3,5
     * @param delimiter |
     * @param separator ,
     * @param keySep    :
     * @return 2, 3, 4|2,3,5
     */
    public String evaluate(String strA, String strB, String delimiter, String separator, String keySep) {

        if (StringUtils.isBlank(strA) || StringUtils.isBlank(strB) || StringUtils.isBlank(separator)) {
            return null;
        }
        String[] strASplit = StringUtils.split(strA, separator);
        if (ArrayUtils.isEmpty(strASplit)) {
            return null;
        }
        String[] strBSplit = StringUtils.split(strB, delimiter);
        if (ArrayUtils.isEmpty(strBSplit)) {
            return null;
        }
        List<String> keyList = Arrays.asList(strASplit);
        List<String> vectorList = Lists.newArrayList();
        for (String kv : strBSplit) {
            String[] split = StringUtils.split(kv, keySep);
            if (keyList.contains(split[0])) {
                vectorList.add(split[1]);
            }
        }

        return StringUtils.join(vectorList, delimiter);
    }
}
