package cn.com.duiba.udf;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by clemac on 17/2/16.
 */
public class VaildClickCount2 extends UDF {

    public String evaluate(String strTimes, Long interval){
        try {
            if(StringUtils.isBlank(strTimes)){
                return "";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List<String> result = new ArrayList<String>();
            String[] times = strTimes.split(",");
            if(times.length <= 0){
                return "";
            }
            Date now = sdf.parse(times[0]);
            result.add(times[0]);
            Date after = new Date(now.getTime() + 60000*interval);
            for(String tstr : times){
                if(tstr.compareTo(sdf.format(after)) > 0){
                    now = sdf.parse(tstr);
                    after.setTime(now.getTime() + 60000*interval);
                    result.add(tstr);
                }
            }
            return StringUtils.join(result, ',');
        } catch (Exception e) {
            return null;
        }
    }

}