package cn.com.duiba.udf;

import org.apache.hadoop.hive.ql.exec.UDF;

/**
 * Created by clemac on 17/2/16.
 */
public class IpConvertLong2 extends UDF {

    public Long evaluate(String strip){
        if(strip.split("\\.").length != 4){
            return null;
        }
        try {
            long[]ip=new long[4];
            int position1=strip.indexOf(".");
            int position2=strip.indexOf(".",position1+1);
            int position3=strip.indexOf(".",position2+1);
            ip[0]=Long.parseLong(strip.substring(0,position1));
            ip[1]=Long.parseLong(strip.substring(position1+1,position2));
            ip[2]=Long.parseLong(strip.substring(position2+1,position3));
            ip[3]=Long.parseLong(strip.substring(position3+1));
            return(ip[0]<<24)+(ip[1]<<16)+(ip[2]<<8)+ip[3];//ip1*256*256*256+ip2*256*256+ip3*256+ip4
        } catch (Exception e) {
            return null;
        }
    }

}
