package cn.com.duiba.utils;

import com.google.common.base.Joiner;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;


public class Wgs84ToBd09Util {

    static double x_pi = 3.14159265358979324 * 3000.0 / 180.0;
    static double pi = 3.1415926535897932384626; // π
    static double a = 6378245.0; //长半轴
    static double ee = 0.00669342162296594323; //偏心率平方

    public static String evaluate(String gps_longitude, String gps_latitude) {
        try {
            if (StringUtils.isEmpty(gps_longitude) || StringUtils.isEmpty(gps_latitude)) {
                return "";
            }

            Double lng = Double.valueOf(gps_longitude);
            Double lat = Double.valueOf(gps_latitude);

           /* if (outOfChina(lng, lat)) {
                return gps_longitude + "," + gps_latitude;
            }*/

            double[] wgs84_to_gcj02 = wgs84_to_gcj02(lng, lat);
            double[] gcj02_to_bd09 = gcj02_to_bd09(wgs84_to_gcj02[0], wgs84_to_gcj02[1]);

            return gcj02_to_bd09[0] + "," + gcj02_to_bd09[1];
        } catch (Exception e) {
            return "";
        }
    }

    boolean outOfChina(Double lng, Double lat) {

        return !(lng > 73.66 && lng < 135.05 && lat > 3.86 && lat < 53.55);
    }

    /**
     * WGS84转GCJ02(火星坐标系)
     * :param lng:WGS84坐标系的经度
     * :param lat:WGS84坐标系的纬度
     * :return:
     *
     * @param lng
     * @param lat
     */
    static double[] wgs84_to_gcj02(Double lng, Double lat) {
        double dlat = _transformlat(lng - 105.0, lat - 35.0);
        double dlng = _transformlng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * pi;
        double magic = Math.sin(radlat);
        magic = 1 - ee * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = (dlat * 180.0) / ((a * (1 - ee)) / (magic * sqrtmagic) * pi);
        dlng = (dlng * 180.0) / (a / sqrtmagic * Math.cos(radlat) * pi);
        double mglat = lat + dlat;
        double mglng = lng + dlng;

        double[] gps = new double[2];
        gps[0] = mglng;
        gps[1] = mglat;

        return gps;
    }

    static double _transformlat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat +
                0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * pi) + 20.0 *
                Math.sin(2.0 * lng * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * pi) + 40.0 *
                Math.sin(lat / 3.0 * pi)) * 2.0 / 3.0;
        ret += (160.0 * Math.sin(lat / 12.0 * pi) + 320 *
                Math.sin(lat * pi / 30.0)) * 2.0 / 3.0;
        return ret;
    }

    static double _transformlng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng +
                0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * pi) + 20.0 *
                Math.sin(2.0 * lng * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * pi) + 40.0 *
                Math.sin(lng / 3.0 * pi)) * 2.0 / 3.0;
        ret += (150.0 * Math.sin(lng / 12.0 * pi) + 300.0 *
                Math.sin(lng / 30.0 * pi)) * 2.0 / 3.0;
        return ret;
    }

    /**
     * 火星坐标系(GCJ-02)转百度坐标系(BD-09)
     * 谷歌、高德——>百度
     * :param lng:火星坐标经度
     * :param lat:火星坐标纬度
     * :return:
     */
    static double[] gcj02_to_bd09(double lng, double lat) {
        double z = Math.sqrt(lng * lng + lat * lat) + 0.00002 * Math.sin(lat * x_pi);
        double theta = Math.atan2(lat, lng) + 0.000003 * Math.cos(lng * x_pi);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        double[] gps = new double[2];
        gps[0] = bd_lng;
        gps[1] = bd_lat;

        return gps;
    }


    public static void main(String[] args) {
        Wgs84ToBd09Util wgs84ToBd09UDF = new Wgs84ToBd09Util();
        String gps_bd = wgs84ToBd09UDF.evaluate("120.107209", "30.290245");
        System.out.println(gps_bd);


        String ipOri = "115.60.89.29";
        String[] splits = ipOri.split("\\.");
        List<String> ipParts = new ArrayList<>();
        for (int i=0;i<3;i++) {

            String split = splits[i];
            int length = split.length();
            if(length==3){
                ipParts.add(split);
            }else if(length==2){
                ipParts.add("0"+split);
            }else if(length==1){
                ipParts.add("00"+ipParts);
            }
        }

        String ipAfter = Joiner.on("").join(ipParts);
        System.out.println(ipAfter);

    }

}
