package cn.com.duiba.udf;


import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;

import java.util.Set;

/**
 * 字符串交集
 */
public class StringIntersectionUDF extends UDF {

    //参数  a b  字符串 单字符串信息需要测试下
    public String evaluate(String stra, String strb, String delimiter) {
        //判断输入字符串不为null
        if (StringUtils.isBlank(stra) || StringUtils.isBlank(strb) || "|".equals(delimiter)) {
            return null;
        }
        //共同的元素值
        Set<String> setA = Sets.newHashSet(StringUtils.split(stra, delimiter));
        Set<String> setB = Sets.newHashSet(StringUtils.split(strb, delimiter));
        //去重复数据
        setA.retainAll(setB);

        return setA.size() == 0 ? null : StringUtils.join(setA, delimiter) + "|" + setA.size();
    }
}
